Create or Replace PACKAGE pkg_ALKINDI_STAT
AS
  PROCEDURE sp_INS_ReCalc_Prod_Stat(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_User_Stat(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_PC_Stat(
    i_OMEGA             IN      NUMBER,
    i_DSCORE                IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_UC_Stat(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_Prod_UC_Stat(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_User_PC_Stat(
    i_OMEGA             IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_User_UC_Stat(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_User_SF_Stat(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_UPD_ReCalc_ProductScore(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_PROD_PC_STAT(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_USER_DATA_STAT(
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_USER_DATA_STAT_1(
    i_USER_ID           IN      USER_ID.USER_ID%TYPE,
    o_ERROR_CODE        OUT     NUMBER);

  PROCEDURE sp_UPD_USER_SUBGROUP;

  PROCEDURE sp_INS_ReCalc_ALKINDEX_STAT(
    i_DSCORE                IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER);

  PROCEDURE sp_INS_ReCalc_UC_SUBGROUP_STAT(
    i_TopN                  IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER);

END pkg_ALKINDI_STAT;
/

Create or Replace PACKAGE BODY pkg_ALKINDI_STAT
AS

PROCEDURE sp_INS_ReCalc_Prod_Stat (
  o_ERROR_CODE OUT NUMBER
) IS
BEGIN
  o_ERROR_CODE := 0;

  execute immediate '
    TRUNCATE TABLE PROD_STAT
  ';


  INSERT INTO PROD_STAT (
    PRODUCT_ID,
    PROD_WEIGHT
  )
    SELECT
      PRODUCT_ID,
      1/COUNT(PRODUCT_CLUSTER_ID)
    FROM
      REL_PRODUCT_CLUSTER
    GROUP BY
      PRODUCT_ID;

  UPDATE PROD_STAT S SET (
    PRODUCT_TYPE_ID
  ) = (
    SELECT
      PRODUCT_TYPE_ID
    FROM
      PRODUCT P
    WHERE
      S.PRODUCT_ID = P.PRODUCT_ID
  ), (
    S.TOT_USER_SEEN,
    S.AVG_USER_EVAL
  ) = (
    SELECT
      COUNT(E.EVALUATION_SCALE_ID),
      NVL(AVG(E.EVALUATION_SCALE_ID), 0)
    FROM
      RATING E
    WHERE
      E.PRODUCT_ID = S.PRODUCT_ID
  ), (
    S.TOT_USER_EVAL
  ) = (
    SELECT
      COUNT(E.EVALUATION_SCALE_ID)
    FROM
      EVALUATION E
    WHERE
      E.PRODUCT_ID = S.PRODUCT_ID
  ), (
    SCORE1
  ) = (
    SELECT
      NVL(
        (-3*count(EVALUATION_SCALE_ID) +
        sum(decode(EVALUATION_SCALE_ID,2,1,3,1,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,6,1,0))
        ),0) SC1
    FROM
      RATING E
    WHERE
      E.PRODUCT_ID = S.PRODUCT_ID
  ),
  S.NEW_ADDITION_IND = 0; -- Mark all Products as old --

  UPDATE PROD_STAT S1 SET (
    S1.FRN_USER_SEEN
  ) = (
    SELECT
      DECODE(TOT_USER_SEEN, 0, 0, s2.TOT_USER_SEEN/s2.TOT_USER_EVAL)
    FROM
      PROD_STAT S2
    WHERE
      S1.PRODUCT_ID = S2.PRODUCT_ID
  );

  END sp_INS_ReCalc_Prod_Stat;

-- ==========================================================================================

PROCEDURE sp_INS_ReCalc_User_Stat (
  o_ERROR_CODE OUT NUMBER)
IS
BEGIN
  o_ERROR_CODE := 0;

  execute immediate '
    TRUNCATE TABLE USER_STAT
  ';

  INSERT INTO USER_STAT (
    USER_ID
  )
  SELECT
    DISTINCT USER_ID
  FROM REL_USER_CLUSTER;

  UPDATE USER_STAT S SET (
    S.AVG_PROD_EVAL, S.TOT_PROD_SEEN
  ) = (
    SELECT
      NVL(AVG(E.EVALUATION_SCALE_ID),0),
      COUNT(E.EVALUATION_SCALE_ID)
    FROM
      RATING E -- [RC] 2001/04/25: was EVALUATION WHERE E.EVALUATION_SCALE_ID >= 1
    WHERE
      E.USER_ID = S.USER_ID
  ), (
    S.TOT_PROD_EVAL
  ) = (
    SELECT
      COUNT(E.EVALUATION_SCALE_ID)
    FROM
      EVALUATION E
    WHERE
      E.USER_ID = S.USER_ID
  ), (
    tot_core_prod_eval
  ) = (
    select
      count(E.EVALUATION_SCALE_ID)
    from
      EVALUATION E
    where
      E.user_id = S.user_id and
      exists (
        select 'x'
        from
          CORE_PROD CP
        where
          CP.product_id = E.product_id
      )
  ), (
    tot_selectable_prod_eval
  ) = (
    select
      count(E.EVALUATION_SCALE_ID)
    from
      EVALUATION E
    where
      E.user_id = S.user_id and
      exists (
        select 'x'
        from
          SELECTABLE_PROD SP
        where
          SP.product_id = E.product_id
      )
  );


    UPDATE USER_STAT S1
       SET (S1.FRN_PROD_SEEN) = (SELECT DECODE(s2.TOT_PROD_EVAL, 0, 0, s2.TOT_PROD_SEEN/s2.TOT_PROD_EVAL)
      FROM USER_STAT S2
     WHERE S1.USER_ID = S2.USER_ID);



--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6302;

  END sp_INS_ReCalc_User_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_PC_Stat(
    i_OMEGA             IN      NUMBER,
    i_DSCORE                IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER)
  IS
    v_Cursor_Truncate   NUMBER;
    v_Truncate_String   VARCHAR2(100);

    TYPE T_C IS REF CURSOR;
    v_CURSOR T_C;
    v_PCID NUMBER;
    v_GOOD NUMBER(8,3);
    v_BAD NUMBER(8,3);
   BEGIN
    o_ERROR_CODE    := 0;
    v_CURSOR_Truncate   := DBMS_SQL.OPEN_CURSOR;
    v_Truncate_String:= 'TRUNCATE TABLE PC_STAT';
    dbms_sql.parse(v_CURSOR_Truncate, v_Truncate_String, DBMS_SQL.V7);
    DBMS_SQL.CLOSE_CURSOR(V_CURSOR_Truncate);

    INSERT INTO PC_STAT (
      PRODUCT_CLUSTER_ID,
      TOT_PROD_IN_PC
    )
    SELECT
      PRODUCT_CLUSTER_ID,
      COUNT(PRODUCT_ID)
    FROM
      REL_PRODUCT_CLUSTER
    GROUP BY
      PRODUCT_CLUSTER_ID;

    UPDATE PC_STAT S
       SET (S.WGT_TOT_PROD_IN_PC) = (SELECT SUM(P.PROD_WEIGHT)
      FROM PROD_STAT P, REL_PRODUCT_CLUSTER R
     WHERE P.PRODUCT_ID = R.PRODUCT_ID
       AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

    UPDATE PC_STAT S
       SET (S.TOT_NEW_PROD_IN_PC, S.WGT_TOT_NEW_PROD_IN_PC) = (SELECT COUNT(P.PRODUCT_ID), NVL(SUM(P.PROD_WEIGHT), 0)
      FROM PROD_STAT P, REL_PRODUCT_CLUSTER R
     WHERE P.NEW_ADDITION_IND = 1
       AND P.PRODUCT_ID = R.PRODUCT_ID
       AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

    UPDATE PC_STAT S
       SET (S.TOT_OLD_PROD_IN_PC, S.WGT_TOT_OLD_PROD_IN_PC) = (SELECT COUNT(P.PRODUCT_ID), SUM(P.PROD_WEIGHT)
      FROM PROD_STAT P, REL_PRODUCT_CLUSTER R
     WHERE P.NEW_ADDITION_IND = 0
       AND P.PRODUCT_ID = R.PRODUCT_ID
       AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

    UPDATE PC_STAT S
       SET (S.OME_WGT_TOT_OLD_PROD_IN_PC) = (SELECT SUM(P.PROD_WEIGHT)
      FROM PROD_STAT P, REL_PRODUCT_CLUSTER R
     WHERE P.NEW_ADDITION_IND = 0
       AND P.PRODUCT_ID = R.PRODUCT_ID
       AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
       AND P.TOT_USER_SEEN < i_OMEGA);

    UPDATE PC_STAT S
       SET (S.OME_TOT_OLD_FRN_USER_SEEN) = (SELECT NVL(SUM(P.FRN_USER_SEEN),0)
      FROM PROD_STAT P, REL_PRODUCT_CLUSTER R
     WHERE P.NEW_ADDITION_IND = 0
       AND P.PRODUCT_ID = R.PRODUCT_ID
       AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
       AND P.TOT_USER_SEEN < i_OMEGA);

    UPDATE PC_STAT S
       SET (TOT_CLUSTERABLE_PROD_IN_PC) =
     (SELECT COUNT(PRODUCT_ID)
      FROM CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
     WHERE R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

    UPDATE PC_STAT S1
       SET (S1.FRN_CLUSTERABLE_PROD_IN_PC) = (SELECT DECODE(s2.TOT_PROD_IN_PC, 0, 0, s2.TOT_CLUSTERABLE_PROD_IN_PC/s2.TOT_PROD_IN_PC)
      FROM PC_STAT S2
     WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID);

    OPEN v_CURSOR FOR
        SELECT PRODUCT_CLUSTER_ID
          FROM PRODUCT_CLUSTER;
    LOOP
        FETCH v_CURSOR INTO v_PCID;
        EXIT WHEN v_CURSOR%NOTFOUND;

    SELECT SUM(DECODE(E.EVALUATION_SCALE_ID,5,1,6,1,0))
         , SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,3,1,4,1,0))
      INTO v_GOOD
         , v_BAD
      FROM EVALUATION E
     WHERE E.EVALUATION_SCALE_ID >=1
       AND E.PRODUCT_ID IN
     (SELECT PRODUCT_ID
      FROM (SELECT PRODUCT_ID
        FROM PROD_UC_STAT
     WHERE PRODUCT_CLUSTER_ID = v_PCID
  ORDER BY SCORE1 DESC
         )
       WHERE ROWNUM < i_DSCORE);

--ORDERBYROWNUM

    UPDATE PC_STAT
       SET FRN_BAD_REC = NVL((v_BAD / (v_GOOD + v_BAD)),0)
     WHERE PRODUCT_CLUSTER_ID = v_PCID;

    END LOOP;
    CLOSE v_CURSOR;


--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6303;

  END sp_INS_ReCalc_PC_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_UC_Stat(
    o_ERROR_CODE            OUT     NUMBER)
  IS
--  v_Cursor        NUMBER;
--  v_Truncate_String   VARCHAR2(100);
   BEGIN
    o_ERROR_CODE    := 0;

--  v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
--  v_Truncate_String:= 'TRUNCATE TABLE UC_STAT';
--  dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
--  DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

--  INSERT INTO UC_STAT (USER_CLUSTER_ID, USER_CLUSTER_INDEX, PRODUCT_CLUSTER_ID, TOT_USER_IN_UC)
--  SELECT DISTINCT UC.USER_CLUSTER_ID, UC.USER_CLUSTER_INDEX, UC.PRODUCT_CLUSTER_ID, COUNT(R.USER_ID)
--    FROM REL_USER_CLUSTER R, USER_CLUSTER UC
--   WHERE R.USER_CLUSTER_ID(+) = UC.USER_CLUSTER_ID
--    GROUP BY UC.USER_CLUSTER_ID, UC.USER_CLUSTER_INDEX, UC.PRODUCT_CLUSTER_ID;

      update uc_stat ucs set tot_user_in_uc = (
      SELECT
        COUNT(R.USER_ID)
      FROM
        REL_USER_CLUSTER R
      WHERE
        R.USER_CLUSTER_ID = ucs.user_cluster_id);

      -- [RC] was:
--      update uc_stat ucs set tot_user_in_uc = (
--      SELECT
--        COUNT(R.USER_ID)
--      FROM
--        REL_USER_CLUSTER R,
--        USER_CLUSTER UC
--      WHERE
--        UC.user_cluster_id = ucs.user_cluster_id and
--        R.USER_CLUSTER_ID(+) = UC.USER_CLUSTER_ID);

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6304;

  END sp_INS_ReCalc_UC_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_USER_PC_Stat(
    i_OMEGA             IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER)
  IS
    v_Cursor        NUMBER;
    v_Truncate_String   VARCHAR2(100);
   BEGIN
    o_ERROR_CODE    := 0;
    v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
    v_Truncate_String:= 'TRUNCATE TABLE USER_PC_STAT';
    dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
    DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

-- One entry per user for each product cluster that has a CORE product evaluated for that user --
--  INSERT INTO USER_PC_STAT (USER_ID, PRODUCT_CLUSTER_ID)
--  SELECT DISTINCT USER_ID, PRODUCT_CLUSTER_ID
--    FROM EVALUATION, REL_CLUSTERABLE_PROD_CLUSTER
--   WHERE EVALUATION.PRODUCT_ID = REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_ID(+)
--     and EVALUATION.EVALUATION_SCALE_ID > 0;

--  INSERT INTO USER_PC_STAT (USER_ID, PRODUCT_CLUSTER_ID)
--  SELECT USER_ID, PRODUCT_CLUSTER_ID
--    FROM REL_USER_CLUSTER;

-- One entry per user for each product cluster that is related to a user cluster the user is in --
-- [The outter joins and "is null"s are a fast way to do "NOT IN", to avoid the lines already existent] --
    INSERT INTO USER_PC_STAT (USER_ID, PRODUCT_CLUSTER_ID)
    SELECT R.USER_ID, R.PRODUCT_CLUSTER_ID
      FROM REL_USER_CLUSTER R,
           USER_PC_STAT S
     WHERE R.USER_ID = S.USER_ID(+) and
           R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID(+) and
           S.USER_ID is null and S.PRODUCT_CLUSTER_ID is null;

    UPDATE USER_PC_STAT S
       SET (S.TOT_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
     WHERE E.PRODUCT_ID = R.PRODUCT_ID --(+)
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

    UPDATE USER_PC_STAT S
       SET (S.FRN_OF_PC_EVAL) = (SELECT DECODE(PC.TOT_CLUSTERABLE_PROD_IN_PC, 0, 0, S.TOT_PROD_EVAL/PC.TOT_CLUSTERABLE_PROD_IN_PC) -- [RC] 2001/04/27: was PC.TOT_PROD_IN_PC
      FROM PC_STAT PC
     WHERE S.PRODUCT_CLUSTER_ID = PC.PRODUCT_CLUSTER_ID);

    UPDATE USER_PC_STAT S
       SET (S.TOT_PROD_SEEN, S.AVG_PROD_RAT) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
      FROM RATING E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
     WHERE E.PRODUCT_ID = R.PRODUCT_ID(+)
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);
       -- [RC] 2001/04/16: was AVG_PROD_EVAL

    UPDATE USER_PC_STAT S1
       SET (S1.FRN_OF_EVAL_SEEN) = (SELECT DECODE(S2.TOT_PROD_EVAL, 0, 0, S2.TOT_PROD_SEEN/S2.TOT_PROD_EVAL)
      FROM USER_PC_STAT S2
     WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
       AND S1.USER_ID = S2.USER_ID);

    UPDATE USER_PC_STAT S
       SET (S.TOT_NEW_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
         , PROD_STAT P
     WHERE E.PRODUCT_ID = R.PRODUCT_ID
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
        AND P.PRODUCT_ID = R.PRODUCT_ID
       AND P.NEW_ADDITION_IND = 1);

    UPDATE USER_PC_STAT S
       SET (S.TOT_NEW_PROD_SEEN, AVG_NEW_PROD_RAT) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
         , PROD_STAT P
     WHERE E.PRODUCT_ID = R.PRODUCT_ID
       AND E.EVALUATION_SCALE_ID >= 1
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
        AND P.PRODUCT_ID = R.PRODUCT_ID
       AND P.NEW_ADDITION_IND = 1);
       -- [RC] 2001/04/16: was AVG_NEW_PROD_EVAL

    UPDATE USER_PC_STAT S1
       SET (S1.FRN_OF_NEW_EVAL_SEEN) = (SELECT DECODE(S2.TOT_NEW_PROD_EVAL, 0, 0, S2.TOT_NEW_PROD_SEEN/S2.TOT_NEW_PROD_EVAL)
      FROM USER_PC_STAT S2
     WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
       AND S1.USER_ID = S2.USER_ID);

    UPDATE USER_PC_STAT S
       SET (S.TOT_OLD_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
         , PROD_STAT P
     WHERE E.PRODUCT_ID = R.PRODUCT_ID
       AND E.PRODUCT_ID = P.PRODUCT_ID
       AND P.NEW_ADDITION_IND = 0
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

    UPDATE USER_PC_STAT S
       SET (S.TOT_OLD_PROD_SEEN, AVG_OLD_PROD_RAT) = (SELECT count(E.EVALUATION_SCALE_ID), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC[ 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
         , PROD_STAT P
     WHERE E.PRODUCT_ID = R.PRODUCT_ID
       AND E.EVALUATION_SCALE_ID >= 1
       AND E.PRODUCT_ID = P.PRODUCT_ID
       AND P.NEW_ADDITION_IND = 0
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);
       -- [RC] 2001/04/16: was AVG_OLD_PROD_EVAL

    UPDATE USER_PC_STAT S1
       SET (S1.FRN_OF_OLD_EVAL_SEEN) = (SELECT DECODE(S2.TOT_OLD_PROD_EVAL, 0, 0, S2.TOT_OLD_PROD_SEEN/S2.TOT_OLD_PROD_EVAL)
      FROM USER_PC_STAT S2
     WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
       AND S1.USER_ID = S2.USER_ID);

    UPDATE USER_PC_STAT S
       SET (S.OME_TOT_OLD_PROD_EVAL) = (SELECT count(E.EVALUATION_SCALE_ID)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
         , PROD_STAT P
     WHERE E.PRODUCT_ID = R.PRODUCT_ID
       AND E.PRODUCT_ID = P.PRODUCT_ID
       AND P.NEW_ADDITION_IND = 0
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
       AND P.TOT_USER_SEEN < i_OMEGA);

    UPDATE USER_PC_STAT S
       SET (S.OME_TOT_OLD_PROD_SEEN) = (SELECT count(E.EVALUATION_SCALE_ID)
      FROM EVALUATION E
         , CORE_PROD_CLUSTER R -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
         , PROD_STAT P
     WHERE E.PRODUCT_ID = R.PRODUCT_ID
       AND E.EVALUATION_SCALE_ID >= 1
       AND E.PRODUCT_ID = P.PRODUCT_ID
       AND P.NEW_ADDITION_IND = 0
       AND E.USER_ID = S.USER_ID
       AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
       AND P.TOT_USER_SEEN < i_OMEGA);

    UPDATE USER_PC_STAT S1
       SET (S1.OME_FRN_OF_OLD_EVAL_SEEN) = (SELECT DECODE(S2.OME_TOT_OLD_PROD_EVAL, 0, 0, S2.OME_TOT_OLD_PROD_SEEN/S2.OME_TOT_OLD_PROD_EVAL)
      FROM USER_PC_STAT S2
     WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
       AND S1.USER_ID = S2.USER_ID);

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6305;

  END SP_INS_RECALC_USER_PC_STAT;

-- ==========================================================================================

PROCEDURE sp_INS_ReCalc_PROD_UC_Stat(
  o_ERROR_CODE OUT NUMBER)
IS
--  v_Cursor        NUMBER;
--  v_Truncate_String   VARCHAR2(100);
BEGIN
  o_ERROR_CODE := 0;
--  v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
--  v_Truncate_String:= 'TRUNCATE TABLE PROD_UC_STAT';
--  dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
--  DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

--  INSERT INTO PROD_UC_STAT (PRODUCT_ID, PRODUCT_INDEX, USER_CLUSTER_ID, USER_CLUSTER_INDEX, PRODUCT_CLUSTER_ID)
--  SELECT DISTINCT R.PRODUCT_ID, R.PRODUCT_INDEX, UC.USER_CLUSTER_ID, UC.USER_CLUSTER_INDEX, UC.PRODUCT_CLUSTER_ID
--    FROM REL_PRODUCT_CLUSTER R, USER_CLUSTER UC
--   WHERE R.PRODUCT_CLUSTER_ID = UC.PRODUCT_CLUSTER_ID;

--  UPDATE PROD_UC_STAT S
--     SET PRODUCT_TYPE_ID = (SELECT PRODUCT_TYPE_ID
--    FROM PRODUCT P
--   WHERE S.PRODUCT_ID = P.PRODUCT_ID);

-- [RC] 2001/04/21: field is not being used anywhere!
--  UPDATE PROD_UC_STAT S
--     SET (S.TOT_USER_EVAL) = (SELECT COUNT(E.PRODUCT_ID)
--    FROM EVALUATION E, REL_USER_CLUSTER R
--   WHERE E.USER_ID = R.USER_ID
--     AND S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
--     AND S.PRODUCT_ID = E.PRODUCT_ID);

  execute immediate '
    drop index i_prod_uc_stat_4_calc
  ';

  UPDATE PROD_UC_STAT S SET
    S.AVG_PROD_RATING_BY_UC = 0 -- was AVG_PROD_EVAL_BY_UC
  WHERE
    not exists (
      select
        'x'
      from
        CORE_PROD_CLUSTER C
      where
        C.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID AND
        C.PRODUCT_ID = S.PRODUCT_ID);

  update prod_uc_stat s set
    s.avg_prod_rating_by_uc = (
  select
    nvl(avg(r.evaluation_scale_id),0)
  from
    RATING r,
    REL_USER_CLUSTER ruc
  where
    ruc.user_cluster_id = s.user_cluster_id and
    r.product_id = s.product_id and
    r.user_id = ruc.user_id) --  [JS] Added to average ONLY "real" ratings / [RC] RATING is used, not EVAL
  where
    exists (
      select 'x'
      from
        RATING r1
      where
        r1.product_id = s.product_id
      group by
        r1.product_id
      having
        count(*) > 0 and
        count(*) < 30);

  UPDATE PROD_UC_STAT S SET (
    S.TOT_USER_SEEN
  ) = (
  SELECT
    COUNT(E.PRODUCT_ID)
  FROM
    RATING E, -- [RC] was EVALUATION E
    REL_USER_CLUSTER R
  WHERE
    E.USER_ID = R.USER_ID AND
    S.USER_CLUSTER_ID = R.USER_CLUSTER_ID AND
    S.PRODUCT_ID = E.PRODUCT_ID  -- [RC] AND E.EVALUATION_SCALE_ID >= 1
  ),
    V = ( -- approximation, see CR # 360
  SELECT
    POWER(PS.AVG_USER_EVAL-S.AVG_PROD_RATING_BY_UC,2)
  FROM
    PROD_STAT PS
  WHERE
    S.PRODUCT_ID = PS.PRODUCT_ID
  );


-- [RC] 2001/04/21: fields are not being used anywhere!
--  UPDATE PROD_UC_STAT S
--     SET (S.FRN_OF_UC_EVAL, S.FRN_OF_UC_SEEN) = (SELECT DECODE(UC.TOT_USER_IN_UC, 0, 0, S.TOT_USER_EVAL/UC.TOT_USER_IN_UC), DECODE(UC.TOT_USER_IN_UC, 0, 0, S.TOT_USER_SEEN/UC.TOT_USER_IN_UC)
--    FROM UC_STAT UC
--   WHERE S.USER_CLUSTER_ID = UC.USER_CLUSTER_ID);


--SELECT product_id,
--     product_cluster_id, POWER((SELECT AVG(S1.AVG_PROD_EVAL_BY_UC)
--                                FROM PROD_UC_STAT S1
--                                WHERE S1.PRODUCT_ID = S.PRODUCT_ID AND
--                                        S1.AVG_PROD_EVAL_BY_UC > 0
--                                GROUP BY S1.PRODUCT_ID) - S.AVG_PROD_EVAL_BY_UC,2)
--FROM PROD_UC_STAT S
--WHERE S.AVG_PROD_EVAL_BY_UC > 0

--  UPDATE PROD_UC_STAT S
--     SET (V) = (SELECT POWER(PS.AVG_USER_EVAL-S.AVG_PROD_EVAL_BY_UC,2)
--    FROM PROD_STAT PS
--   WHERE S.PRODUCT_ID = PS.PRODUCT_ID);

--  UPDATE PROD_UC_STAT S1
--     SET (S1.AVG_V_BY_PC) = (SELECT AVG(V)
--    FROM PROD_UC_STAT S2
--   WHERE S1.PRODUCT_ID = S2.PRODUCT_ID
--     AND S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
--     AND S2.AVG_PROD_EVAL_BY_UC > 0
--    GROUP BY S1.PRODUCT_ID, S1.PRODUCT_CLUSTER_ID);

/* -- [RC] 2001/04/23: merged into one update statement
    UPDATE PROD_UC_STAT S
       SET (V) = (SELECT POWER(PS.AVG_USER_EVAL-S.AVG_PROD_RATING_BY_UC,2)
      FROM PROD_STAT PS
     WHERE S.PRODUCT_ID = PS.PRODUCT_ID);
*/

  sp_UPD_ReCalc_ProductScore(o_ERROR_CODE);

  execute immediate '
    create index
    i_prod_uc_stat_4_calc on prod_uc_stat (
      product_id,
      product_cluster_id,
      avg_prod_rating_by_uc
    ) tablespace alkindi_clt1_x
  ';

-- [RC[ 2001/04/20: the statement above runs in 11 minutes on DEV

-- [RC] 2001/04/21: fields are not being used anywhere!
--  UPDATE PROD_UC_STAT S1
--     SET (S1.AVG_V_BY_PC) = (SELECT AVG(V)
--    FROM PROD_UC_STAT S2
--   WHERE S1.PRODUCT_ID = S2.PRODUCT_ID
--     AND S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
--     AND S2.AVG_PROD_RATING_BY_UC > 0
--   GROUP BY S1.PRODUCT_ID, S1.PRODUCT_CLUSTER_ID);

-- MSW 102000
--  UPDATE PROD_UC_STAT S
--     SET (S.AVG_PROD_RATING_BY_UC) = (SELECT NVL(SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,2,3,3,4,4,5,5,6,6,0))/COUNT(E.EVALUATION_SCALE_ID),0)
--    FROM EVALUATION E, REL_USER_CLUSTER R
--   WHERE E.USER_ID = R.USER_ID
--     AND S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
--     AND S.PRODUCT_ID = E.PRODUCT_ID);

--EXCEPTION
--  WHEN OTHERS THEN
--    o_ERROR_CODE := 6306;

END sp_INS_ReCalc_PROD_UC_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_USER_UC_Stat(
    o_ERROR_CODE            OUT     NUMBER)
  IS
    v_Cursor        NUMBER;
    v_Truncate_String   VARCHAR2(100);
   BEGIN
    o_ERROR_CODE    := 0;
--  v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
--  v_Truncate_String:= 'TRUNCATE TABLE USER_UC_STAT';
--  dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
--  DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

--  INSERT INTO USER_UC_STAT (USER_ID, USER_CLUSTER_ID, PRODUCT_CLUSTER_ID)
--  SELECT R.USER_ID, UC.USER_CLUSTER_ID, UC.PRODUCT_CLUSTER_ID
--    FROM REL_USER_CLUSTER R, USER_CLUSTER UC
--   WHERE R.USER_CLUSTER_ID = UC.USER_CLUSTER_ID(+);

-- [RC] 2001/04/21: It's not used anywhere!
--  UPDATE USER_UC_STAT S
--     SET (S.CALC_M2) = (SELECT NVL(SUM(POWER(E.EVALUATION_SCALE_ID - PUCS.AVG_PROD_RATING_BY_UC, 2))/SUM(PUCS.SIGMA_SQUARED),0)
--    FROM EVALUATION E, PROD_UC_STAT PUCS
--   WHERE PUCS.PRODUCT_ID = E.PRODUCT_ID
--     AND E.EVALUATION_SCALE_ID >= 1
--     AND E.USER_ID = S.USER_ID
--     AND PUCS.USER_CLUSTER_ID = S.USER_CLUSTER_ID);
-- [RC] 2001/04/16: line 2 was PUCS.AVG_PROD_EVAL_BY_UC

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6307;

  END sp_INS_ReCalc_USER_UC_Stat;

-- ==========================================================================================

PROCEDURE sp_INS_ReCalc_USER_SF_Stat(
  o_ERROR_CODE OUT NUMBER)
IS
BEGIN
 -- [RC] 2001/04/24: It has to be changed:
 -- What matters is the most recent -2, -3 or -4 for each (user_id, sf_id, pc_id)

  execute immediate '
    TRUNCATE TABLE USER_SF_STAT
  ';

  insert into USER_SF_STAT (
    user_id,
    scoring_function_id,
    product_cluster_id,
    tot_int,
    tot_not_int,
    tot_not_kno
  )
  select
    E.user_id,
    R.scoring_function_id,
    R.product_cluster_id,
    sum(decode(E.evaluation_scale_id,-2,1,0)) I,
    sum(decode(E.evaluation_scale_id,-3,1,0)) NI,
    sum(decode(E.evaluation_scale_id,-4,1,0)) DK
  from
  (
    select
      user_id,
      product_id,
      evaluation_scale_id
    from
      EVALUATION E0
    where
      E0.evaluation_scale_id in (-2,-3,-4)
    union all
    select
      user_id,
      product_id,
      evaluation_scale_id
    from
      EVALUATION_HISTORY E1
    where
      E1.evaluation_scale_id in (-2,-3,-4) and
      not exists (
        select 'x'
        from
          EVALUATION_HISTORY E2
        where
          E2.user_id = E1.user_id AND
          E2.product_id = E1.product_id AND
          E2.evaluation_scale_id in (-2,-3,-4) AND
          E2.old_evaluation_timestamp > E1.old_evaluation_timestamp
      ) and
      not exists (
        select 'x'
        from
          EVALUATION E3
        where
          E3.user_id = E1.user_id AND
          E3.product_id = E1.product_id AND
          E3.evaluation_scale_id in (-2,-3,-4) AND
          E3.evaluation_timestamp > E1.old_evaluation_timestamp
      )
  ) E,
  (
    select
      user_id,
      product_id,
      scoring_function_id,
      product_cluster_id
    from
      RECOMMENDATION R0
    union all
    select
      user_id,
      product_id,
      scoring_function_id,
      product_cluster_id
    from
      RECOMMENDATION_LOG R1
  ) R
  where
    E.user_id = R.user_id AND
    E.product_id = R.product_id
  group by
    E.user_id,
    R.scoring_function_id,
    R.product_cluster_id;

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6308;
 END sp_INS_ReCalc_USER_SF_Stat;

-- ==========================================================================================

/*
  PROCEDURE sp_INS_ReCalc_USER_SF_Stat_OLD(
    o_ERROR_CODE            OUT     NUMBER)
  IS
    v_Cursor        NUMBER;
    v_Truncate_String   VARCHAR2(100);
   BEGIN

   -- [RC] 2001/04/24: It has to be changed:
   -- What matters is the most recent -2, -3 or -4 for each (user_id, sf_id, pc_id)


    o_ERROR_CODE    := 0;
    v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
    v_Truncate_String:= 'TRUNCATE TABLE USER_SF_STAT';
    dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
    DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

    INSERT INTO USER_SF_STAT (USER_ID, SCORING_FUNCTION_ID, TOT_REC)
    SELECT USER_ID, SCORING_FUNCTION_ID, COUNT(SCORING_FUNCTION_ID)
      FROM RECOMMENDATION
    GROUP BY USER_ID, SCORING_FUNCTION_ID;

    UPDATE USER_SF_STAT S
       SET (S.TOT_INT) = (SELECT COUNT(EVALUATION_SCALE_ID)
      FROM EVALUATION E, RECOMMENDATION R
     WHERE E.USER_ID(+) = R.USER_ID
       AND E.PRODUCT_ID(+) = R.PRODUCT_ID
       AND E.EVALUATION_SCALE_ID = -2
       AND R.SCORING_FUNCTION_ID = S.SCORING_FUNCTION_ID
       AND R.USER_ID = S.USER_ID);

    UPDATE USER_SF_STAT S
       SET (S.TOT_NOT_INT) = (SELECT COUNT(EVALUATION_SCALE_ID)
      FROM EVALUATION E, RECOMMENDATION R
     WHERE E.USER_ID(+) = R.USER_ID
       AND E.PRODUCT_ID(+) = R.PRODUCT_ID
       AND E.EVALUATION_SCALE_ID = -3
       AND R.SCORING_FUNCTION_ID = S.SCORING_FUNCTION_ID
       AND R.USER_ID = S.USER_ID);

    UPDATE USER_SF_STAT S
       SET (S.TOT_NOT_KNO) = (SELECT COUNT(EVALUATION_SCALE_ID)
      FROM EVALUATION E, RECOMMENDATION R
     WHERE E.USER_ID(+) = R.USER_ID
       AND E.PRODUCT_ID(+) = R.PRODUCT_ID
       AND E.EVALUATION_SCALE_ID = -4
       AND R.SCORING_FUNCTION_ID = S.SCORING_FUNCTION_ID
       AND R.USER_ID = S.USER_ID);

   EXCEPTION
    WHEN OTHERS THEN
        o_ERROR_CODE    := 6308;
 END sp_INS_ReCalc_USER_SF_Stat_OLD;
*/
-- ==========================================================================================

PROCEDURE sp_UPD_ReCalc_ProductScore(
  o_ERROR_CODE OUT NUMBER)
IS
BEGIN
  o_ERROR_CODE := 0;

  UPDATE /*+ index(REL_PRODUCT_CLUSTER PK_REL_PRODUCT_CLUSTER) */
   PROD_UC_STAT S
  SET (
    SCORE1,
    SCORE2,
    SCORE3,
    SCORE4,
    SCORE5
  ) = (
    SELECT
      NVL(MIN(
        (-3*count(EVALUATION_SCALE_ID) +
        sum(decode(EVALUATION_SCALE_ID,2,1,3,1,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,6,1,0))
        ) ),0) SC1,
      NVL(MIN(
        sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0))
        ),0) SC2,
      NVL(MIN(
        -1*count(*) +
        sum(decode(EVALUATION_SCALE_ID,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0))),0) SC3,
      NVL(MIN(
        (-3*count(EVALUATION_SCALE_ID) +
        sum(decode(EVALUATION_SCALE_ID,2,1,3,1,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,4,1,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0)) +
        sum(decode(EVALUATION_SCALE_ID,6,1,0))
        ) / count(EVALUATION_SCALE_ID)),0) SC4,
      NVL(MIN(
        (sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0))
        ) / count(*)),0) SC5
    FROM
      EVALUATION E,
      REL_USER_CLUSTER R,
      REL_PRODUCT_CLUSTER RC
    WHERE
      E.EVALUATION_SCALE_ID >=1 and
      E.USER_ID = R.USER_ID and
      E.PRODUCT_ID = RC.PRODUCT_ID /* and E.PRODUCT_ID (+) = RC.PRODUCT_ID */ and
      R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID and
      S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID and
      S.USER_CLUSTER_ID = R.USER_CLUSTER_ID and
      S.PRODUCT_ID = E.PRODUCT_ID
    GROUP BY
      RC.PRODUCT_CLUSTER_ID,
      R.USER_CLUSTER_ID,
      E.PRODUCT_ID
  );

  -- [RC] 2001/04/27: was
  --,
  --SCORE2 = (
  --    SELECT
  --      NVL(MIN(COUNT(*)),0)
  --    FROM
  --      EVALUATION E,
  --      REL_USER_CLUSTER R,
  --      REL_PRODUCT_CLUSTER RC
  --    WHERE
  --      E.EVALUATION_SCALE_ID >=5 and
  --      E.USER_ID = R.USER_ID and
  --      E.PRODUCT_ID = RC.PRODUCT_ID /* and E.PRODUCT_ID (+) = RC.PRODUCT_ID */ and
  --      R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID and
  --      S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID and
  --      S.USER_CLUSTER_ID = R.USER_CLUSTER_ID and
  --      S.PRODUCT_ID = E.PRODUCT_ID
  --    GROUP BY
  --      RC.PRODUCT_CLUSTER_ID,
  --      R.USER_CLUSTER_ID,
  --      E.PRODUCT_ID
  --);

-- [RC] 2001/04/23: merged into one update statement
--  UPDATE /*+ index(REL_PRODUCT_CLUSTER PK_REL_PRODUCT_CLUSTER) */
--  PROD_UC_STAT S
--   SET SCORE2 =
--   (SELECT NVL(MIN(
--     COUNT(*)),0)
--  FROM EVALUATION E, REL_USER_CLUSTER R, REL_PRODUCT_CLUSTER RC
--  WHERE E.EVALUATION_SCALE_ID >=5
--   and E.USER_ID = R.USER_ID
--   and E.PRODUCT_ID = RC.PRODUCT_ID /* and E.PRODUCT_ID (+) = RC.PRODUCT_ID */
--   and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
--   and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
--   and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
--   and S.PRODUCT_ID = E.PRODUCT_ID
--  GROUP BY RC.PRODUCT_CLUSTER_ID,
--   R.USER_CLUSTER_ID,
--   E.PRODUCT_ID);

--  UPDATE PROD_UC_STAT S
--   SET SCORE6 = 0, SCORE7 = 0, SCORE8 = 0;

-- default changed to 0 for SCORE7 and SCORE8 --

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6309;

  END sp_UPD_ReCalc_ProductScore;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_USER_DATA_STAT(
    o_ERROR_CODE            OUT     NUMBER)
  IS
    v_Cursor        NUMBER;
    v_Truncate_String   VARCHAR2(100);
   BEGIN
    o_ERROR_CODE    := 0;
    v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
    v_Truncate_String:= 'TRUNCATE TABLE USER_DATA_STAT';
    dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
    DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

    INSERT INTO USER_DATA_STAT (
      USER_ID,
      PRODUCT_CLUSTER_ID
    )
    SELECT DISTINCT
      R.USER_ID,
      R.PRODUCT_CLUSTER_ID
    FROM
      REL_USER_CLUSTER R;

    UPDATE USER_DATA_STAT S SET (
      NI,
      NEW_PROD_NI,
      NEW_PROD_MI,
      OLD_PROD_OME_NI,
      OLD_PROD_OME_MI
    ) = (
      SELECT
        NVL(WGT_TOT_PROD_IN_PC,0),
        NVL(WGT_TOT_NEW_PROD_IN_PC,0),
        NVL(TOT_NEW_PROD_IN_PC,0),
        NVL(OME_WGT_TOT_OLD_PROD_IN_PC,0),
        NVL(TOT_OLD_PROD_IN_PC,0)
      FROM
        PC_STAT PCS
      WHERE
        S.PRODUCT_CLUSTER_ID = PCS.PRODUCT_CLUSTER_ID
    );

    UPDATE USER_DATA_STAT S SET (
      RI,
      EI,
      FI,
      NEW_PROD_EI,
      OLD_PROD_OME_EI
    ) = (
      SELECT
        NVL(AVG_PROD_RAT,0),
        NVL(FRN_OF_EVAL_SEEN,0),
        NVL(FRN_OF_PC_EVAL,0),
        NVL(FRN_OF_NEW_EVAL_SEEN,0),
        NVL(FRN_OF_OLD_EVAL_SEEN,0)
      FROM
        USER_PC_STAT UPCS
      WHERE
        S.PRODUCT_CLUSTER_ID = UPCS.PRODUCT_CLUSTER_ID AND
        S.USER_ID = UPCS.USER_ID
    );

    UPDATE USER_DATA_STAT S SET (
      RAVE,
      EAVE
    ) = (
      SELECT
        NVL(AVG_PROD_EVAL,0),
        NVL(FRN_PROD_SEEN,0)
      FROM
        USER_STAT US
      WHERE
        S.USER_ID = US.USER_ID
    );

    UPDATE USER_DATA_STAT S SET (
      NEW_PROD_EPI
    ) = (
      SELECT
        NVL(SUM(FRN_USER_SEEN),0)
      FROM
        PROD_STAT PS,
        REL_PRODUCT_CLUSTER R
      WHERE
        PS.PRODUCT_ID = R.PRODUCT_ID AND
        PS.NEW_ADDITION_IND = 1 AND
        S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    );

    UPDATE USER_DATA_STAT S SET (
      OLD_PROD_OME_EPI
    ) = (
      SELECT
        NVL(SUM(FRN_USER_SEEN),0)
      FROM
        PROD_STAT PS,
        REL_PRODUCT_CLUSTER R
      WHERE
        PS.PRODUCT_ID = R.PRODUCT_ID AND
        PS.NEW_ADDITION_IND = 0 AND
        S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    );

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6311;

  END sp_INS_ReCalc_USER_DATA_STAT;

-- ==========================================================================================

-- same as sp_INS_ReCalc_USER_DATA_STAT, but for one user only
  PROCEDURE sp_INS_ReCalc_USER_DATA_STAT_1(
    i_USER_ID           IN      USER_ID.USER_ID%TYPE,
    o_ERROR_CODE        OUT     NUMBER)
  IS
   BEGIN
    o_ERROR_CODE    := 0;

    INSERT INTO USER_DATA_STAT (
      USER_ID,
      PRODUCT_CLUSTER_ID
    )
    SELECT DISTINCT
      R.USER_ID,
      R.PRODUCT_CLUSTER_ID
    FROM
      REL_USER_CLUSTER R
    WHERE
      R.USER_ID = i_USER_ID;

    UPDATE USER_DATA_STAT S SET (
      NI,
      NEW_PROD_NI,
      NEW_PROD_MI,
      OLD_PROD_OME_NI,
      OLD_PROD_OME_MI
    ) = (
      SELECT
        NVL(WGT_TOT_PROD_IN_PC,0),
        NVL(WGT_TOT_NEW_PROD_IN_PC,0),
        NVL(TOT_NEW_PROD_IN_PC,0),
        NVL(OME_WGT_TOT_OLD_PROD_IN_PC,0),
        NVL(TOT_OLD_PROD_IN_PC,0)
      FROM
        PC_STAT PCS
      WHERE
        S.PRODUCT_CLUSTER_ID = PCS.PRODUCT_CLUSTER_ID
    )
    WHERE
      S.USER_ID = i_USER_ID;

    UPDATE USER_DATA_STAT S SET (
      RI,
      EI,
      FI,
      NEW_PROD_EI,
      OLD_PROD_OME_EI
    ) = (
      SELECT
        NVL(AVG_PROD_RAT,0),
        NVL(FRN_OF_EVAL_SEEN,0),
        NVL(FRN_OF_PC_EVAL,0),
        NVL(FRN_OF_NEW_EVAL_SEEN,0),
        NVL(FRN_OF_OLD_EVAL_SEEN,0)
      FROM
        USER_PC_STAT UPCS
      WHERE
        S.PRODUCT_CLUSTER_ID = UPCS.PRODUCT_CLUSTER_ID AND
        S.USER_ID = UPCS.USER_ID
    )
    WHERE
      S.USER_ID = i_USER_ID;

    UPDATE USER_DATA_STAT S SET (
      RAVE,
      EAVE
    ) = (
      SELECT
        NVL(AVG_PROD_EVAL,0),
        NVL(FRN_PROD_SEEN,0)
      FROM
        USER_STAT US
      WHERE
        S.USER_ID = US.USER_ID
    )
    WHERE
      S.USER_ID = i_USER_ID;

    UPDATE USER_DATA_STAT S SET (
      NEW_PROD_EPI
    ) = (
      SELECT
        NVL(SUM(FRN_USER_SEEN),0)
      FROM
        PROD_STAT PS,
        REL_PRODUCT_CLUSTER R
      WHERE
        PS.PRODUCT_ID = R.PRODUCT_ID AND
        PS.NEW_ADDITION_IND = 1 AND
        S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    )
    WHERE
      S.USER_ID = i_USER_ID;

    UPDATE USER_DATA_STAT S SET (
      OLD_PROD_OME_EPI
    ) = (
      SELECT
        NVL(SUM(FRN_USER_SEEN),0)
      FROM
        PROD_STAT PS,
        REL_PRODUCT_CLUSTER R
      WHERE
        PS.PRODUCT_ID = R.PRODUCT_ID AND
        PS.NEW_ADDITION_IND = 0 AND
        S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    )
    WHERE
      S.USER_ID = i_USER_ID;

   EXCEPTION
    WHEN OTHERS THEN
        o_ERROR_CODE    := 6311;

  END sp_INS_ReCalc_USER_DATA_STAT_1;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_PROD_PC_STAT(
    o_ERROR_CODE            OUT     NUMBER)
  IS
    v_Cursor        NUMBER;
    v_Truncate_String   VARCHAR2(100);
   BEGIN
    o_ERROR_CODE    := 0;
    v_CURSOR        := DBMS_SQL.OPEN_CURSOR;
    v_Truncate_String:= 'TRUNCATE TABLE PROD_PC_STAT';
    dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
    DBMS_SQL.CLOSE_CURSOR(V_CURSOR);


    INSERT INTO PROD_PC_STAT (PRODUCT_ID, PRODUCT_CLUSTER_ID)
    SELECT R.PRODUCT_ID, R.PRODUCT_CLUSTER_ID
      FROM SELECTABLE_PROD_CLUSTER R; -- [RC] 2001/04/27: was FROM REL_PRODUCT_CLUSTER R;

--  UPDATE PROD_PC_STAT S
--     SET PRODUCT_TYPE_ID = (SELECT PRODUCT_TYPE_ID
--    FROM PRODUCT P
--   WHERE S.PRODUCT_ID = P.PRODUCT_ID);

--  UPDATE PROD_PC_STAT S
--     SET (S.TOT_USER_SEEN, S.AVG_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
--    FROM EVALUATION E, REL_PRODUCT_CLUSTER R
--   WHERE E.EVALUATION_SCALE_ID >= 1
--     AND E.PRODUCT_ID = S.PRODUCT_ID
--     AND E.PRODUCT_ID = R.PRODUCT_ID
--     AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

--  UPDATE PROD_PC_STAT S
--     SET (S.TOT_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID)
--    FROM EVALUATION E, REL_PRODUCT_CLUSTER R
--   WHERE E.PRODUCT_ID = S.PRODUCT_ID
--     AND E.PRODUCT_ID = R.PRODUCT_ID
--     AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

--  UPDATE PROD_PC_STAT S1
--     SET (S1.FRN_USER_SEEN) = (SELECT DECODE(TOT_USER_SEEN, 0, 0, s2.TOT_USER_SEEN/s2.TOT_USER_EVAL)
--    FROM PROD_PC_STAT S2
--   WHERE S1.PRODUCT_ID = S2.PRODUCT_ID
--     AND S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID);

-- [RC] 2001/04/21: PRODUCT_TYPE, TOT_USER_SEEN, AVG_USER_EVAL, TOT_USER_EVAL,
-- NEW_ADDITION_IND and FRN_USER_SEEN are desnormalizations from table PROD_STAT!

    UPDATE PROD_PC_STAT S SET (
      PRODUCT_TYPE_ID,
      TOT_USER_SEEN,
      TOT_USER_EVAL,
      FRN_USER_SEEN,
      AVG_USER_EVAL,
      NEW_ADDITION_IND
    ) = (
    SELECT
      PRODUCT_TYPE_ID,
      TOT_USER_SEEN,
      TOT_USER_EVAL,
      FRN_USER_SEEN,
      AVG_USER_EVAL,
      NEW_ADDITION_IND
    FROM
      PROD_STAT PS
    WHERE
      PS.PRODUCT_ID = S.PRODUCT_ID
    );

    -- [RC] 2001/04/21: no need for group by

    UPDATE PROD_PC_STAT S SET
      S.AVG_V = (
    SELECT
      AVG(PUCS.V)
    FROM
      PROD_UC_STAT PUCS
    WHERE
      PUCS.PRODUCT_ID = S.PRODUCT_ID AND
      PUCS.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID AND
      PUCS.TOT_USER_SEEN > 0-- [RC] 2001/04/16: was AVG_PROD_EVAL_BY_UC
    );

    -- was:
--  UPDATE PROD_PC_STAT S
--     SET (S.AVG_V) = (SELECT AVG(PUCS.V)
--    FROM PROD_UC_STAT PUCS
--   WHERE S.PRODUCT_ID = PUCS.PRODUCT_ID
--     AND S.PRODUCT_CLUSTER_ID = PUCS.PRODUCT_CLUSTER_ID
--     AND PUCS.AVG_PROD_RATING_BY_UC > 0 -- [RC] 2001/04/16: was AVG_PROD_EVAL_BY_UC
--    GROUP BY S.PRODUCT_ID, S.PRODUCT_CLUSTER_ID);

--   EXCEPTION
--  WHEN OTHERS THEN
--      o_ERROR_CODE    := 6312;

  END sp_INS_ReCalc_PROD_PC_STAT;

-- ==========================================================================================

  PROCEDURE sp_UPD_USER_SUBGROUP IS

--This gets all the PC, US and counts of users in UC
    CURSOR c_cursor IS
    SELECT PRODUCT_CLUSTER_ID
             , USER_CLUSTER_ID
         , COUNT(USER_ID) AS v_COUNT_USER
      FROM REL_USER_CLUSTER
    GROUP BY PRODUCT_CLUSTER_ID
         , USER_CLUSTER_ID;

    TYPE T_C IS REF CURSOR;
    v_RANK T_C;

    v_cursor     c_cursor%ROWTYPE;
    v_PC_ID      NUMBER;
    v_UC_ID      NUMBER;
    v_COUNT_USER NUMBER;
    v_USER_ID    NUMBER;
    v_LOOP1  NUMBER;
    v_INDEX  NUMBER;
    v_NUM_OF_SUB NUMBER;
    BEGIN


    OPEN c_cursor;

FETCH c_cursor into v_cursor;

V_PC_ID := v_cursor.PRODUCT_CLUSTER_ID;
v_UC_ID := v_cursor.USER_CLUSTER_ID;
v_COUNT_USER := v_cursor.v_COUNT_USER;

WHILE c_cursor%FOUND LOOP

IF v_COUNT_USER <= 6 THEN
    v_NUM_OF_SUB := 1;
ELSIF v_COUNT_USER <= 12 THEN
    v_NUM_OF_SUB := 2;
ELSE
    v_NUM_OF_SUB := 4;
END IF;

    OPEN v_RANK FOR

SELECT RUC.USER_ID
  FROM EVALUATION E, REL_USER_CLUSTER RUC, CORE_PROD_CLUSTER RPC -- [RC] 2001/04/17: was REL_CLUSTERABLE_PROD_CLUSTER
WHERE E.USER_ID = RUC.USER_ID
  AND E.PRODUCT_ID = RPC.PRODUCT_ID
  AND RUC.USER_CLUSTER_ID = v_UC_ID
  AND RPC.PRODUCT_CLUSTER_ID = v_PC_ID
GROUP BY RUC.USER_ID
ORDER BY COUNT(E.PRODUCT_ID) ASC;

FETCH v_RANK INTO v_USER_ID;
v_LOOP1 := 1;
v_INDEX := 0;

WHILE v_RANK%FOUND LOOP

IF (v_COUNT_USER/v_NUM_OF_SUB) >=  v_LOOP1 THEN
    v_INDEX := 0;
ELSIF (2*(v_COUNT_USER/v_NUM_OF_SUB)) >= v_LOOP1 THEN
    v_INDEX := 1;
ELSIF (3*(v_COUNT_USER/v_NUM_OF_SUB)) >= v_LOOP1 THEN
    v_INDEX := 2;
ELSE
    v_INDEX := 3;
END IF;

UPDATE REL_USER_CLUSTER
   SET USER_CLUSTER_SUBGROUP_INDEX = v_INDEX
 WHERE USER_ID = v_USER_ID
   AND USER_CLUSTER_ID = v_UC_ID;

v_LOOP1 := v_LOOP1 + 1;
FETCH v_RANK INTO v_USER_ID;

END LOOP;

FETCH c_cursor into v_cursor;

V_PC_ID := v_cursor.PRODUCT_CLUSTER_ID;
v_UC_ID := v_cursor.USER_CLUSTER_ID;
v_COUNT_USER := v_cursor.v_COUNT_USER;

END LOOP;

CLOSE c_cursor;

 END sp_UPD_USER_SUBGROUP;

-- ==========================================================================================
 -- [RC] 2001/04/17: for compatibility until calls from MW are changed
  PROCEDURE sp_INS_ReCalc_ALKINDEX_STAT(
    i_DSCORE                IN      NUMBER,
    o_ERROR_CODE            OUT     NUMBER)
  IS
  BEGIN
    sp_INS_ReCalc_UC_SUBGROUP_STAT(i_DSCORE, o_ERROR_CODE);
  END sp_INS_ReCalc_ALKINDEX_STAT;

-- ==========================================================================================

PROCEDURE sp_INS_ReCalc_UC_SUBGROUP_STAT (
  i_TopN       IN NUMBER,
  o_ERROR_CODE OUT NUMBER
) IS
  TYPE T_C IS REF CURSOR;
  v_CURSOR T_C;
  v_SGID NUMBER;
  v_SGIDX NUMBER;
  v_UCID NUMBER;
  v_GOOD_b NUMBER(8,3);
  v_BAD_b NUMBER(8,3);
  v_GOOD_BB NUMBER(8,3);
  v_BAD_BB NUMBER(8,3);
BEGIN
  o_ERROR_CODE := 0;

  OPEN v_CURSOR FOR
  SELECT DISTINCT
    USER_CLUSTER_ID,
    USER_CLUSTER_SUBGROUP_INDEX
  FROM
    REL_USER_CLUSTER;

  LOOP
    FETCH v_CURSOR INTO v_UCID, v_SGIDX;
    EXIT WHEN v_CURSOR%NOTFOUND;

    SELECT
      SUM(DECODE(E.EVALUATION_SCALE_ID,5,1,6,1,0)),
      SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,3,1,4,1,0))
    INTO
      v_GOOD_b,
      v_BAD_b
    FROM
      EVALUATION E,
      REL_USER_CLUSTER R
    WHERE
      E.USER_ID = R.USER_ID AND
      R.USER_CLUSTER_SUBGROUP_INDEX = v_SGIDX AND
      R.USER_CLUSTER_ID = v_UCID AND
      E.EVALUATION_SCALE_ID >= 1 AND
      E.PRODUCT_ID IN (
        SELECT
          PRODUCT_ID
        FROM
          (SELECT PRODUCT_ID
           FROM PROD_UC_STAT
           WHERE USER_CLUSTER_ID = v_UCID
           ORDER BY SCORE1 DESC
          )
        WHERE
          ROWNUM < i_TopN
      );

    SELECT
      SUM(DECODE(E.EVALUATION_SCALE_ID,5,1,6,1,0)),
      SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,3,1,4,1,0))
    INTO
      v_GOOD_BB,
      v_BAD_BB
    FROM
      EVALUATION E,
      REL_USER_CLUSTER R
    WHERE
      E.USER_ID = R.USER_ID AND
      R.USER_CLUSTER_SUBGROUP_INDEX = v_SGIDX AND
      R.USER_CLUSTER_ID = v_UCID AND
      E.EVALUATION_SCALE_ID >= 1 AND
      E.PRODUCT_ID IN (
        SELECT
          PRODUCT_ID
        FROM
          (SELECT PRODUCT_ID
           FROM PROD_STAT           --  **** what's different from Bi calculation ****
           ORDER BY SCORE1 DESC
          )
        WHERE
          ROWNUM < i_TopN
      );


    UPDATE UC_SUBGROUP_STAT SET (
      BBI,
      BI
    ) = (
      SELECT
        NVL((v_BAD_BB / (v_GOOD_BB + v_BAD_BB)),0),
        NVL((v_BAD_b / (v_GOOD_b + v_BAD_b)),0)
      FROM
        DUAL -- dummy table just to select from somewhere
    )
    WHERE
      USER_CLUSTER_ID = v_UCID AND
      USER_CLUSTER_SUBGROUP_INDEX = v_SGIDX;

  END LOOP;

  CLOSE v_CURSOR;

  UPDATE UC_SUBGROUP_STAT S SET (
    NI
  ) = (
  SELECT
    WGT_TOT_PROD_IN_PC
  FROM
    PC_STAT PCS
  WHERE
    S.PRODUCT_CLUSTER_ID = PCS.PRODUCT_CLUSTER_ID
  );

END sp_INS_ReCalc_UC_SUBGROUP_STAT;

END pkg_ALKINDI_STAT;
/
